---
type: glossary
tags:
  - "#layer/information"
  - "#status/stable"
  - "#function/observation"
---

# Resilience (diagnostic)

> Time to return near the fixed point (closure) after a disturbance.

---

## Definition

- Recovery time measure
- Return path dynamics
- Restoration speed
- Healing capacity

---

## Dual‑register mapping

### Technical (network/computational)

| Diagnostic concept | Network construct | Test example |
|-------------------|------------------|--------------|
| Recovery time | MTTR metric | `Monitor`, `Time` |
| Return path | State track | `Check`, `Path` |
| Restoration | Fix speed | `Test`, `Speed` |

### Humane (biological/relational)

| Diagnostic concept | Humane construct | Example |
|-------------------|------------------|----------|
| Recovery time | Healing time | "Gets better" |
| Return path | Way back | "Finds home" |
| Restoration | Mending pace | "Heals well" |

### Crosswalk (bridge)

| Technical term | Humane term | Ontological meaning |
|---------------|-------------|-------------------|
| MTTR metric | Healing time | How recovery works |
| State track | Way back | How return flows |
| Fix speed | Mending pace | How healing moves |

### Domain Examples

| Domain | Technical test | Humane test |
|--------|---------------|-------------|
| Physics | Damping time | Natural return |
| Networks | Fix time | Link heal |
| Cognition | Focus return | Mind heal |
| Systems | State fix | Flow return |

---

## Scale Effects

How Resilience manifests differently at various scales:

### Micro Scale (ε-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ε | Quantum fix | Wave heal |
| λV | Gate return | State fix |

### Human Scale (ψA-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ψA | Phase return | Pattern heal |
| ∇S | Structure fix | Clear return |

### Cosmic Scale (c-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| c | Wave return | Light heal |
| λV | Field fix | Space return |

Note: At extreme scales, resilience faces fundamental limits (e.g., quantum recovery at ε, causal return at c).

---

## Invariants / Thresholds

Scale-dependent bounds:
- ε: fix tolerance met
- c: return within limit
- ψA: phase recovers
- λV: gates restore

---

## SVA Coupling

Scale-dependent modulator effects:

| Scale | Modulator | Technical effect | Humane effect |
|-------|-----------|-----------------|---------------|
| Micro | ∇S | Pattern fix | Wave heal |
| Human | λV | Gate return | Flow restore |
| Cosmic | ψA | Phase heal | Field return |

---

## Failure Modes

Scale-dependent failure patterns:

| Scale | Mode | Technical signature | Humane signature |
|-------|------|-------------------|------------------|
| Micro | Slow fix | Pattern drift | Won't heal |
| Human | No return | Path lost | Can't find way |
| Cosmic | Field drift | Structure wander | Lost return |

---

## Diagnostic Checklist

Technical tests:
- [ ] Recovery time good
- [ ] Return path clear
- [ ] Fix speed right
- [ ] State tracks

Humane tests:
- [ ] Heals naturally
- [ ] Finds way back
- [ ] Mends well
- [ ] Flow returns

---

## Design rationale

This diagnostic must maintain dual-register intelligibility per governance (see [PRINCIPLES.md](../../../../PRINCIPLES.md)). Neither technical recovery nor experiential healing alone captures its full meaning.

---

## See Also

- [[Stability Margin (diagnostic)]]
- [[Robustness (diagnostic)]]
- [[Metastability (diagnostic)]]
- [[Form]]
- [[Field]]

---

## Dual‑register checklist

- [x] Technical mapping provided
- [x] Humane mapping provided
- [x] Crosswalk table included
- [x] Scale-aware tests documented